function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 333);

T = World_Economy_Cartel_Fracking_VD.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(266) = T(34)*T(34)*T(34)*T(34);
T(267) = (T(34)*T(34)*(exp(y(29))*T(34)+exp(y(29))*exp(y(29))-(exp(y(29))*exp(y(29))+exp(y(29))*exp(y(29))))-(exp(y(29))*T(34)-exp(y(29))*exp(y(29)))*(exp(y(29))*T(34)+exp(y(29))*T(34)))/T(266);
T(268) = (T(34)*T(34)*exp(y(30))*exp(y(29))-(exp(y(29))*T(34)-exp(y(29))*exp(y(29)))*(exp(y(30))*T(34)+exp(y(30))*T(34)))/T(266);
T(269) = (T(34)*T(34)*exp(y(29))*exp(y(52))-(exp(y(29))*T(34)-exp(y(29))*exp(y(29)))*(exp(y(52))*T(34)+exp(y(52))*T(34)))/T(266);
T(270) = (T(34)*T(34)*(-(exp(y(30))*exp(y(29))))-(-(exp(y(30))*exp(y(29))))*(exp(y(30))*T(34)+exp(y(30))*T(34)))/T(266);
T(271) = (-((-(exp(y(30))*exp(y(29))))*(exp(y(52))*T(34)+exp(y(52))*T(34))))/T(266);
T(272) = (T(34)*T(34)*(-(exp(y(29))*exp(y(52))))-(-(exp(y(29))*exp(y(52))))*(exp(y(52))*T(34)+exp(y(52))*T(34)))/T(266);
T(273) = (T(34)*T(34)*(-(exp(y(30))*exp(y(29))))-(-(exp(y(30))*exp(y(29))))*(exp(y(29))*T(34)+exp(y(29))*T(34)))/T(266);
T(274) = (T(34)*T(34)*(exp(y(30))*T(34)+exp(y(30))*exp(y(30))-(exp(y(30))*exp(y(30))+exp(y(30))*exp(y(30))))-(exp(y(30))*T(34)-exp(y(30))*exp(y(30)))*(exp(y(30))*T(34)+exp(y(30))*T(34)))/T(266);
T(275) = (T(34)*T(34)*exp(y(30))*exp(y(52))-(exp(y(30))*T(34)-exp(y(30))*exp(y(30)))*(exp(y(52))*T(34)+exp(y(52))*T(34)))/T(266);
T(276) = (T(34)*T(34)*(-(exp(y(30))*exp(y(52))))-(-(exp(y(30))*exp(y(52))))*(exp(y(52))*T(34)+exp(y(52))*T(34)))/T(266);
T(277) = T(33)*T(33)*T(33)*T(33);
T(278) = (T(33)*T(33)*(T(32)*T(33)+T(32)*T(32)-(T(32)*T(32)+T(32)*T(32)))-(T(32)*T(33)-T(32)*T(32))*(T(32)*T(33)+T(32)*T(33)))/T(277);
T(279) = (T(33)*T(33)*exp(y(32))*T(32)-(T(32)*T(33)-T(32)*T(32))*(exp(y(32))*T(33)+exp(y(32))*T(33)))/T(277);
T(280) = (T(33)*T(33)*exp(y(53))*T(32)-(T(32)*T(33)-T(32)*T(32))*(exp(y(53))*T(33)+exp(y(53))*T(33)))/T(277);
T(281) = (T(33)*T(33)*(-(exp(y(32))*T(32)))-(-(exp(y(32))*T(32)))*(exp(y(32))*T(33)+exp(y(32))*T(33)))/T(277);
T(282) = (-((-(exp(y(32))*T(32)))*(exp(y(53))*T(33)+exp(y(53))*T(33))))/T(277);
T(283) = (T(33)*T(33)*(-(exp(y(53))*T(32)))-(-(exp(y(53))*T(32)))*(exp(y(53))*T(33)+exp(y(53))*T(33)))/T(277);
T(284) = (T(33)*T(33)*(-(exp(y(32))*T(32)))-(-(exp(y(32))*T(32)))*(T(32)*T(33)+T(32)*T(33)))/T(277);
T(285) = (T(33)*T(33)*(exp(y(32))*T(33)+exp(y(32))*exp(y(32))-(exp(y(32))*exp(y(32))+exp(y(32))*exp(y(32))))-(exp(y(32))*T(33)-exp(y(32))*exp(y(32)))*(exp(y(32))*T(33)+exp(y(32))*T(33)))/T(277);
T(286) = (T(33)*T(33)*exp(y(32))*exp(y(53))-(exp(y(32))*T(33)-exp(y(32))*exp(y(32)))*(exp(y(53))*T(33)+exp(y(53))*T(33)))/T(277);
T(287) = (T(33)*T(33)*(-(exp(y(32))*exp(y(53))))-(-(exp(y(32))*exp(y(53))))*(exp(y(53))*T(33)+exp(y(53))*T(33)))/T(277);
T(288) = T(49)+T(57)+params(25)*y(125)*exp(y(34))*params(6)*params(5)*params(5)*exp(params(5)*y(38));
T(289) = getPowerDeriv(T(9),T(10),3);
T(290) = T(169)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(291) = T(5)*T(290);
T(292) = T(161)+T(160)+exp(y(43))*(T(159)+exp(y(43))*exp(y(43))*getPowerDeriv(exp(y(43)),T(11),3));
T(293) = y(71)*(-(T(90)*T(19)*T(16)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(161)+T(5)*T(19)*T(92)*exp(T(1)*y(50))*(1-params(11))*params(3)*T(161)))+y(70)*(-(T(94)*T(3)*T(16)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(161)+T(17)*T(3)*T(92)*exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(161)));
T(294) = y(71)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(161)))+y(70)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(161)));
T(295) = T(172)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(296) = y(71)*(-(T(5)*(T(16)*T(61)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(172)+T(19)*T(61)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))*T(91)*T(170))))+y(70)*(-(T(17)*(T(16)*T(61)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(169)+T(3)*T(61)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))*T(91)*T(170))));
T(297) = y(71)*(-(T(90)*T(19)*T(62)*T(92)+T(19)*T(16)*T(62)*T(207)+T(90)*T(19)*T(62)*T(92)+T(5)*T(19)*T(62)*T(208)))+y(70)*(-(T(94)*T(3)*T(63)*T(92)+T(17)*T(3)*T(63)*T(208)+T(94)*T(3)*T(63)*T(92)+T(3)*T(16)*T(63)*T(212)));
T(298) = y(71)*(-(T(90)*T(19)*T(16)*T(61)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))+T(5)*T(19)*T(92)*T(61)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))))+y(70)*(-(T(17)*T(3)*T(92)*T(61)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))+T(94)*T(3)*T(16)*T(61)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))));
T(299) = y(71)*(-(T(5)*T(19)*T(16)*T(61)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))))+y(70)*(-(T(17)*T(3)*T(16)*T(61)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(300) = getPowerDeriv(T(72),T(10),3);
T(301) = T(166)+exp(y(111))*exp(y(111))*getPowerDeriv(exp(y(111)),T(11),2);
T(302) = (1-params(11))*(1-params(3))*exp(T(1)*y(116))*T(301);
T(303) = T(185)+T(184)+T(20)*(T(183)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(304) = getPowerDeriv(T(68),T(1),3);
T(305) = getPowerDeriv(T(68),T(13),3);
T(306) = T(65)*T(185)*T(65)*T(66)*T(188)+T(78)*T(65)*T(303)+T(65)*T(185)*T(65)*T(66)*T(188)+T(65)*T(66)*(T(65)*T(185)*T(188)+T(65)*T(66)*T(65)*T(66)*T(305));
T(307) = T(65)*T(185)*T(188)*T(67)*T(224)+T(78)*T(185)*T(224)+T(65)*T(66)*T(188)*T(66)*T(224)+T(65)*T(66)*(T(188)*T(66)*T(224)+T(65)*T(66)*T(67)*T(224)*T(305));
T(308) = T(224)+exp(y(112))*exp(y(112))*getPowerDeriv(exp(y(112)),1-params(3),2);
T(309) = T(66)*T(224)*T(188)*T(67)*T(224)+T(78)*T(66)*T(308)+T(66)*T(224)*T(188)*T(67)*T(224)+T(65)*T(66)*(T(67)*T(224)*T(67)*T(224)*T(305)+T(188)*T(67)*T(308));
T(310) = getPowerDeriv(T(6),T(13),3);
T(311) = T(90)*T(169)*T(170)*T(175)+T(91)*T(90)*T(290)+T(90)*T(169)*T(170)*T(175)+T(3)*T(90)*(T(175)*T(291)+T(170)*T(170)*T(310));
T(312) = getPowerDeriv(T(6),T(1),3);
T(313) = getPowerDeriv(T(27),(-params(14)),2);
T(314) = T(195)*(-(params(9)*(T(193)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(194)*T(194)*T(313);
T(315) = T(28)*exp(y(15))*T(195)+T(28)*exp(y(15))*T(195);
T(316) = getPowerDeriv(T(25),(-params(14)),3);
T(317) = T(202)*T(85)*T(203)+T(86)*(-(params(9)*(T(201)+T(200)+T(4)*(T(199)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(202)*T(85)*T(203)+T(85)*(T(202)*T(203)+T(85)*T(85)*T(316));
T(318) = T(207)+T(206)+T(4)*(T(205)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(319) = T(3)*T(207)*T(3)*T(90)*T(175)+T(91)*T(3)*T(318)+T(3)*T(207)*T(3)*T(90)*T(175)+T(3)*T(90)*(T(175)*T(3)*T(207)+T(3)*T(90)*T(3)*T(90)*T(310));
T(320) = getPowerDeriv(T(98),(-params(14)),2);
T(321) = params(1)*(T(230)*(-(params(9)*(T(228)+exp(y(112))*exp(y(112))*getPowerDeriv(exp(y(112)),1+params(8),2))/(1+params(8))))+T(229)*T(229)*T(320));
T(322) = y(71)*(-(T(90)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))+T(5)*T(19)*T(92)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(50))));
T(323) = y(70)*(-(T(94)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))+T(17)*T(3)*T(92)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(324) = T(237)+exp(y(46))*exp(y(46))*T(203)+exp(y(46))*(exp(y(46))*T(203)+exp(y(46))*exp(y(46))*T(316));
T(325) = getPowerDeriv(exp(y(65)-y(51)),params(5)-1,3);
T(326) = (T(34)*T(34)*(-(exp(y(29))*exp(y(52))))-(-(exp(y(29))*exp(y(52))))*(exp(y(29))*T(34)+exp(y(29))*T(34)))/T(266);
T(327) = (-((-(exp(y(29))*exp(y(52))))*(exp(y(30))*T(34)+exp(y(30))*T(34))))/T(266);
T(328) = (T(34)*T(34)*(-(exp(y(30))*exp(y(52))))-(-(exp(y(30))*exp(y(52))))*(exp(y(30))*T(34)+exp(y(30))*T(34)))/T(266);
T(329) = (T(34)*T(34)*(exp(y(52))*T(34)+exp(y(52))*exp(y(52))-(exp(y(52))*exp(y(52))+exp(y(52))*exp(y(52))))-(exp(y(52))*T(34)-exp(y(52))*exp(y(52)))*(exp(y(52))*T(34)+exp(y(52))*T(34)))/T(266);
T(330) = (T(33)*T(33)*(-(exp(y(53))*T(32)))-(-(exp(y(53))*T(32)))*(T(32)*T(33)+T(32)*T(33)))/T(277);
T(331) = (-((-(exp(y(53))*T(32)))*(exp(y(32))*T(33)+exp(y(32))*T(33))))/T(277);
T(332) = (T(33)*T(33)*(-(exp(y(32))*exp(y(53))))-(-(exp(y(32))*exp(y(53))))*(exp(y(32))*T(33)+exp(y(32))*T(33)))/T(277);
T(333) = (T(33)*T(33)*(exp(y(53))*T(33)+exp(y(53))*exp(y(53))-(exp(y(53))*exp(y(53))+exp(y(53))*exp(y(53))))-(exp(y(53))*T(33)-exp(y(53))*exp(y(53)))*(exp(y(53))*T(33)+exp(y(53))*T(33)))/T(277);

end
